;;  Programm:      ACM-DREHBEZ.LSP
;;  Befehlsaufruf: ACM-DREHBEZ
;;  Funktion:      Dreht Objekte oder deren Kopie um einen Basispunkt anhand eines
;;                 Bezugswinkels und eines neuen Winkels.
;;  Autor:         Gerhard Rampf
;;                 Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;                 Liebigstr. 3 A
;;                 86399 Bobingen
;;                 E-Mail: rampf@geracad.de
;;  Datum:         06.04.2023
;;  Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-drehbez ( / drb28 drb00 drb32 drb33 drb34 drb35 brd01 brd02 brd03 brd04 brd05 brd06 brd07 brd08 brd09 brd10 brd11)
    (defun brd01 (drb01 / )
        (if drb33 (setq *error* drb33))
        (if drb29
          (vl-catch-all-apply 'setvar (list "AUNITS" drb29))
        )
        (if drb28
          (vl-catch-all-apply 'setvar (list "CMDECHO" drb28))
        )
        (if drb12
          (vl-catch-all-apply 'setvar (list "OSMODE" drb12))
        )
        (if drb22
          (vl-catch-all-apply 'setvar (list "ORTHOMODE" drb22))
        )
        (if drb00
          (vl-catch-all-apply 'setvar (list "AUTOSNAP" drb00))
        )
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
    (defun brd02 ( / drb05)
      (setq drb05 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= drb05 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq drb06 T)
            (setq drb06 nil)
        )
        (if (not drb06)
          (alert "\042acm-drehbez\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      drb06
    )
    (defun brd03 ( / drb07 drb08 drb09)
      (if
        (and
          (setq drb07 (vl-filename-mktemp "acm.dcl"))
          (setq drb08 (open drb07 "w"))
        )
          (progn
            (setq drb09
              (list
                "omodi"
                ":dialog{label=\042Einstellungen\042;"
                ":spacer{height=0.3;}"
                ":boxed_column{label=\042Objektfangmodi\042;"
                ":radio_button{key=\042ofmaktuelle\042;label=\042Aktuelle &verwenden\042;}"
                ":row{"
                ":radio_button{key=\042ofmbefabh\042;label=\042&Befehlsabh. verw.\042;}"
                ":button{key=\042...\042;label=\042...\042;}}}"
                ":boxed_column{label=\042Orthomodus\042;"
                ":radio_button{key=\042omoaktuelle\042;label=\042A&ktuellen verwenden\042;}"
                ":radio_button{key=\042omobefabh\042;label=\042Be&fehlsabh. verw.\042;}"
                ":row{"
                ":spacer{width=0;}"
                ":toggle{key=\042orthoein\042;label=\042&Ortho ein\042;}"
                ":spacer{width=9;}}}"
                ":spacer{height=0;}"
                ":toggle{key=\042kopie\042;label=\042Kopie &drehen\042;}"
                ":spacer{height=0.6;}"
                ":row{"
                ":spacer{width=4;}"
                ":column{width=0;fixed_width=true;"
                ":button{key=\042ok\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042abbrechen\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=4;}}}"
              )
            )
              (while drb09
                (write-line (car drb09) drb08)
                (setq drb09 (cdr drb09))
              )
            (setq drb08 (close drb08))
            drb07
          )
          nil
      )
    )
    (defun brd04 ( / drb07 drb08 drb09)
      (if
        (and
          (setq drb07 (vl-filename-mktemp "acm.dcl"))
          (setq drb08 (open drb07 "w"))
        )
          (progn
            (setq drb09
              (list
                "rotbez"
                ":dialog{label=\042Befehlsabh. Objektfangmodi\042;"
                ":spacer{height=0.5;}"
                ":row{"
                ":spacer{width=0;}"
                ":column{"
                ":toggle{key=\042endpunkt\042;label=\042&Endpunkt\042;}"
                ":toggle{key=\042mittelpunkt\042;label=\042&Mittelpunkt\042;}"
                ":toggle{key=\042zentrum\042;label=\042&Zentrum\042;}"
                ":toggle{key=\042geomzentrum\042;label=\042Ge&om. Zentr.\042;}"
                ":toggle{key=\042punkt\042;label=\042P&unkt\042;}"
                ":toggle{key=\042quadrant\042;label=\042&Quadrant\042;}"
                ":toggle{key=\042schnittpunkt\042;label=\042&Schnittpunkt\042;}}"
                ":column{"
                ":toggle{key=\042hilfslinie\042;label=\042H&ilfslinie\042;}"
                ":toggle{key=\042basispunkt\042;label=\042&Basispunkt\042;}"
                ":toggle{key=\042lot\042;label=\042&Lot\042;}"
                ":toggle{key=\042tangente\042;label=\042Ta&ngente\042;}"
                ":toggle{key=\042naechsterpunkt\042;label=\042N&chster Punkt\042;}"
                ":toggle{key=\042angenschnittp\042;label=\042&Angen. Schnittp.\042;}"
                ":toggle{key=\042parallel\042;label=\042&Parallel\042;}}}"
                ":spacer{height=0.6;}"
                ":row{"
                ":spacer{width=4;}"
                ":column{width=0;fixed_width=true;"
                ":button{key=\042ok\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042abbrechen\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=4;}}}"
              )
            )
              (while drb09
                (write-line (car drb09) drb08)
                (setq drb09 (cdr drb09))
              )
            (setq drb08 (close drb08))
            drb07
          )
          nil
      )
    )
    (defun brd05 ( / drb10 drb11 drb12 drb06)
        (if (setq drb10 (brd04))
          (progn
            (setq drb11 (load_dialog drb10))
              (if (not (new_dialog "rotbez" drb11))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list drb10))
            (setq drb12 (getvar "OSMODE"))
              (if (= (type (vl-catch-all-apply 'setvar (list "OSMODE" acmdrehbez03202301globvar))) 'VL-CATCH-ALL-APPLY-ERROR)
                (setq acmdrehbez03202301globvar 0)
              )
            (setvar "OSMODE" drb12)
            (setq drb14 acmdrehbez03202301globvar)
              (if (= (logand acmdrehbez03202301globvar 1) 1)
                (set_tile "endpunkt" "1")
              )
              (if (= (logand acmdrehbez03202301globvar 2) 2)
                (set_tile "mittelpunkt" "1")
              )
              (if (= (logand acmdrehbez03202301globvar 4) 4)
                (set_tile "zentrum" "1")
              )
              (if (= (logand acmdrehbez03202301globvar 8) 8)
                (set_tile "punkt" "1")
              )
              (if (= (logand acmdrehbez03202301globvar 16) 16)
                (set_tile "quadrant" "1")
              )
              (if (= (logand acmdrehbez03202301globvar 32) 32)
                (set_tile "schnittpunkt" "1")
              )
              (if (= (logand acmdrehbez03202301globvar 64) 64)
                (set_tile "basispunkt" "1")
              )
              (if (= (logand acmdrehbez03202301globvar 128) 128)
                (set_tile "lot" "1")
              )
              (if (= (logand acmdrehbez03202301globvar 256) 256)
                (set_tile "tangente" "1")
              )
              (if (= (logand acmdrehbez03202301globvar 512) 512)
                (set_tile "naechsterpunkt" "1")
              )
              (if (= (logand acmdrehbez03202301globvar 1024) 1024)
                (set_tile "geomzentrum" "1")
              )
              (if (= (logand acmdrehbez03202301globvar 2048) 2048)
                (set_tile "angenschnittp" "1")
              )
              (if (= (logand acmdrehbez03202301globvar 4096) 4096)
                (set_tile "hilfslinie" "1")
              )
              (if (= (logand acmdrehbez03202301globvar 8192) 8192)
                (set_tile "parallel" "1")
              )
            (action_tile "ok" "(setq drb06 (setq acmdrehbez03202301globvar (brd06))) (done_dialog)")
            (action_tile "abbrechen" "(setq drb06 drb14) (done_dialog)")
            (start_dialog)
            (unload_dialog drb11)
          )
        )
      drb06
    )
    (defun brd06 ( / )
      (setq acmdrehbez03202301globvar 0)
        (if (= (get_tile "endpunkt") "1")
          (setq acmdrehbez03202301globvar (+ acmdrehbez03202301globvar 1))
        )
        (if (= (get_tile "mittelpunkt") "1")
          (setq acmdrehbez03202301globvar (+ acmdrehbez03202301globvar 2))
        )
        (if (= (get_tile "zentrum") "1")
          (setq acmdrehbez03202301globvar (+ acmdrehbez03202301globvar 4))
        )
        (if (= (get_tile "punkt") "1")
          (setq acmdrehbez03202301globvar (+ acmdrehbez03202301globvar 8))
        )
        (if (= (get_tile "quadrant") "1")
          (setq acmdrehbez03202301globvar (+ acmdrehbez03202301globvar 16))
        )
        (if (= (get_tile "schnittpunkt") "1")
          (setq acmdrehbez03202301globvar (+ acmdrehbez03202301globvar 32))
        )
        (if (= (get_tile "basispunkt") "1")
          (setq acmdrehbez03202301globvar (+ acmdrehbez03202301globvar 64))
        )
        (if (= (get_tile "lot") "1")
          (setq acmdrehbez03202301globvar (+ acmdrehbez03202301globvar 128))
        )
        (if (= (get_tile "tangente") "1")
          (setq acmdrehbez03202301globvar (+ acmdrehbez03202301globvar 256))
        )
        (if (= (get_tile "naechsterpunkt") "1")
          (setq acmdrehbez03202301globvar (+ acmdrehbez03202301globvar 512))
        )
        (if (= (get_tile "geomzentrum") "1")
          (setq acmdrehbez03202301globvar (+ acmdrehbez03202301globvar 1024))
        )
        (if (= (get_tile "angenschnittp") "1")
          (setq acmdrehbez03202301globvar (+ acmdrehbez03202301globvar 2048))
        )
        (if (= (get_tile "hilfslinie") "1")
          (setq acmdrehbez03202301globvar (+ acmdrehbez03202301globvar 4096))
        )
        (if (= (get_tile "parallel") "1")
          (setq acmdrehbez03202301globvar (+ acmdrehbez03202301globvar 8192))
        )
      acmdrehbez03202301globvar
    )
    (defun brd07 ( / drb10 drb11 drb15 drb06)
        (if (setq drb10 (brd03))
          (progn
            (setq drb11 (load_dialog drb10))
              (if (not (new_dialog "omodi" drb11))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list drb10))
            (setq drb15 acmdrehbez03202301globvar)
              (if (= acmdrehbez03202302globvar 0)
                (progn
                  (set_tile "ofmaktuelle" "1")
                  (mode_tile "..." 1)
                )
                (set_tile "ofmbefabh" "1")
              )
              (if (= acmdrehbez03202303globvar 0)
                (progn
                  (set_tile "omoaktuelle" "1")
                  (mode_tile "orthoein" 1)
                )
                (set_tile "omobefabh" "1")
              )
            (set_tile "orthoein" (itoa acmdrehbez03202304globvar))
              (if (= acmdrehbez03202305globvar 1)
                (set_tile "kopie" "1")
              )
            (action_tile "ofmaktuelle" "(set_tile \"ofmbefabh\" \"0\") (mode_tile \"...\" 1)")
            (action_tile "ofmbefabh" "(set_tile \"ofmaktuelle\" \"0\") (mode_tile \"...\" 0) (mode_tile \"...\" 2)")
            (action_tile "omoaktuelle" "(set_tile \"omobefabh\" \"0\") (mode_tile \"orthoein\" 1)")
            (action_tile "omobefabh" "(set_tile \"omoaktuelle\" \"0\") (mode_tile \"orthoein\" 0)")
            (action_tile "..." "(setq acmdrehbez03202301globvar (brd05))")
              (action_tile "ok" "(setq drb06
                  (list
                    (setq acmdrehbez03202302globvar (atoi (get_tile \"ofmbefabh\")))
                    (setq acmdrehbez03202303globvar (atoi (get_tile \"omobefabh\")))
                    (setq acmdrehbez03202304globvar (atoi (get_tile \"orthoein\")))
                    (setq acmdrehbez03202305globvar (atoi (get_tile \"kopie\")))
                  )
                )
               (done_dialog)
               (brd08)"
              )
            (action_tile "abbrechen" "(setq acmdrehbez03202301globvar drb15) (setq drb06 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog drb11)
          )
        )
      drb06
    )
    (defun brd08 ( / drb12)
      (setq drb12 (getvar "OSMODE"))
        (if (= (type (vl-catch-all-apply 'setvar (list "OSMODE" acmdrehbez03202301globvar))) 'VL-CATCH-ALL-APPLY-ERROR)
          (setq acmdrehbez03202301globvar 0)
        )
      (setvar "OSMODE" drb12)
        (if (not (vl-position acmdrehbez03202302globvar (list 0 1)))
          (setq acmdrehbez03202302globvar 0)
        )
        (if (not (vl-position acmdrehbez03202303globvar (list 0 1)))
          (setq acmdrehbez03202303globvar 0)
        )
        (if (not (vl-position acmdrehbez03202304globvar (list 0 1)))
          (setq acmdrehbez03202304globvar 0)
        )
        (if (not (vl-position acmdrehbez03202305globvar (list 0 1)))
          (setq acmdrehbez03202305globvar 0)
        )
        (prompt
          (strcat
            "\nAktuelle Einstellungen: OFANG = "
            (nth acmdrehbez03202302globvar (list "Aktuell" "Befehlsabh."))
            ", ORTHO = "
              (if (= acmdrehbez03202303globvar 0)
                (strcat "Aktuell (" (nth (getvar "ORTHOMODE") (list "Aus" "Ein")) ")")
                (nth acmdrehbez03202304globvar (list "Aus" "Ein"))
              )
            ", Kopie drehen = "
            (nth acmdrehbez03202305globvar (list "Nein" "Ja"))
          )
        )
    )
    (defun brd09 ( / drb12 drb22 drb23 drb24 drb25)
        (if (not (vl-position (type acmdrehbez03202306globvar) (list 'INT 'REAL)))
          (setq acmdrehbez03202306globvar 0.0)
        )
        (if (not (vl-position (type acmdrehbez03202307globvar) (list 'INT 'REAL)))
          (setq acmdrehbez03202307globvar 0.0)
        )
      (setq drb12 (getvar "OSMODE"))
      (setq drb22 (getvar "ORTHOMODE"))
      (setq drb23 "")
        (while (= (type drb23) 'STR)
            (if (= drb23 "Einstellungen")
              (brd07)
            )
            (if (= acmdrehbez03202302globvar 0) 
              (setvar "OSMODE" drb12)
              (setvar "OSMODE" acmdrehbez03202301globvar)
            )
          (initget 8 "Einstellungen")
          (setq drb23 (getpoint "\nBasispunkt angeben oder [Einstellungen]: "))
          (setvar "OSMODE" drb12)
        )
        (if drb23
          (progn
              (if (= acmdrehbez03202302globvar 0) 
                (setvar "OSMODE" drb12)
                (setvar "OSMODE" acmdrehbez03202301globvar)
              )
              (if (= acmdrehbez03202303globvar 0) 
                (setvar "ORTHOMODE" drb22)
                (setvar "ORTHOMODE" acmdrehbez03202304globvar)
              )
            (initget "Einstellungen")
            (setq drb24 (getorient (strcat "\nBezugswinkel angeben oder [Einstellungen] <" (brd10 acmdrehbez03202306globvar) ">: ")))
            (setvar "OSMODE" drb12)
            (setvar "ORTHOMODE" drb22)
              (if (not drb24)
                (setq drb24 acmdrehbez03202306globvar)
              )
              (while (= (type drb24) 'STR)
                (brd07)
                  (if (= acmdrehbez03202302globvar 0) 
                    (setvar "OSMODE" drb12)
                    (setvar "OSMODE" acmdrehbez03202301globvar)
                  )
                  (if (= acmdrehbez03202303globvar 0) 
                    (setvar "ORTHOMODE" drb22)
                    (setvar "ORTHOMODE" acmdrehbez03202304globvar)
                  )
                (initget "Einstellungen")
                (setq drb24 (getorient (strcat "\nBezugswinkel angeben oder [Einstellungen] <" (brd10 acmdrehbez03202306globvar) ">: ")))
                (setvar "OSMODE" drb12)
                (setvar "ORTHOMODE" drb22)
                  (if (not drb24)
                    (setq drb24 acmdrehbez03202306globvar)
                  )
              )
              (if drb24
                (progn
                    (if (= acmdrehbez03202302globvar 0) 
                      (setvar "OSMODE" drb12)
                      (setvar "OSMODE" acmdrehbez03202301globvar)
                    )
                    (if (= acmdrehbez03202303globvar 0) 
                      (setvar "ORTHOMODE" drb22)
                      (setvar "ORTHOMODE" acmdrehbez03202304globvar)
                    )
                  (initget "Einstellungen")
                  (setq drb25 (getorient (strcat "\nNeuen Winkel angeben oder [Einstellungen] <" (brd10 acmdrehbez03202307globvar) ">: ")))
                  (setvar "OSMODE" drb12)
                  (setvar "ORTHOMODE" drb22)
                    (if (not drb25)
                      (setq drb25 acmdrehbez03202307globvar)
                    )
                    (while (= (type drb25) 'STR)
                      (brd07)
                        (if (= acmdrehbez03202302globvar 0) 
                          (setvar "OSMODE" drb12)
                          (setvar "OSMODE" acmdrehbez03202301globvar)
                        )
                        (if (= acmdrehbez03202303globvar 0) 
                          (setvar "ORTHOMODE" drb22)
                          (setvar "ORTHOMODE" acmdrehbez03202304globvar)
                        )
                      (initget "Einstellungen")
                      (setq drb25 (getorient (strcat "\nNeuen Winkel angeben oder [Einstellungen] <" (brd10 acmdrehbez03202307globvar) ">: ")))
                      (setvar "OSMODE" drb12)
                      (setvar "ORTHOMODE" drb22)
                        (if (not drb25)
                          (setq drb25 acmdrehbez03202307globvar)
                        )
                    )
                )
              )
          )
        )
        (if
          (and
            drb23
            drb24
            drb25
          )
            (list
              drb23
              (setq acmdrehbez03202306globvar drb24)
              (setq acmdrehbez03202307globvar drb25)
            )
            nil
        )
    )
    (defun brd10 (drb02 / drb26 drb27 drb06)
      (setq drb26 (getvar "AUPREC"))
      (setq drb27 (getvar "DIMZIN"))
      (setvar "DIMZIN" 8)
      (setvar "AUPREC" 8)
      (setq drb06 (angtos drb02))
      (setvar "DIMZIN" drb27)
      (setvar "AUPREC" drb26)
      drb06
    )
    (defun brd11 (drb03 drb04 / drb28 drb12 drb29)
      (setq drb28 (getvar "CMDECHO"))
      (setq drb12 (getvar "OSMODE"))
      (setq drb29 (getvar "AUNITS"))
      (setvar "CMDECHO" 0)
      (setvar "OSMODE" 0)
        (if (= acmdrehbez03202305globvar 1)
          (vl-cmdf "._copy" drb03 "" (list 0.0 0.0 0.0) (list 0.0 0.0 0.0))
        )
      (setvar "AUNITS" 3)
      (vl-cmdf "._rotate" drb03 "" (car drb04) "_r" (setq drb30 (cadr drb04)) (setq drb31 (caddr drb04)))
      (setvar "AUNITS" drb29)
      (setvar "CMDECHO" drb28)
      (setvar "OSMODE" drb12)
        (prompt
          (strcat
            "\nBezugswinkel = "
            (brd10 drb30)
            ", neuer Winkel = "
            (brd10 drb31)
          )
        )
    )
  (if (brd02)
    (progn
      (vl-load-com)
      (setq drb28 (getvar "CMDECHO"))
      (setq drb00 (getvar "AUTOSNAP"))
      (setvar "CMDECHO" 0)
      (setq drb32 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq drb33 *error*)
      (setq *error* brd01)
      (vla-EndUndoMark drb32)
      (vla-StartUndoMark drb32)
      (prompt "\nMit ACM-DREHBEZ zu drehende Objekte whlen ... ")
        (if (setq drb34 (ssget "_:L"))
          (progn
            (brd08)
              (if (setq drb35 (brd09))
                (brd11 drb34 drb35)
              )
          )
          (prompt "\nKeine Objekte gewhlt. ")
        )
        (if drb33
          (setq *error* drb33)
          (setq *error* nil)
        )
      (setvar "AUTOSNAP" drb00)
      (setvar "CMDECHO" drb28)
      (vla-EndUndoMark drb32)
    )
  )
  (princ)
)
(terpri)
(princ "\nAutoLISP-Tool ACM-DREHBEZ (Copyright  2023 Gerhard Rampf) geladen.")
(princ "\nRufen Sie den Befehl mit ACM-DREHBEZ auf.")
